#!/usr/bin/env python
# -*- coding: utf-8 -*-

###############################################################################
# pci2geotiff_class.py
#
# Auteurs :   Ludovic Granjon, Martin Laloux, redaction@portailsig.org
# Organisme : portailSIG, www.portailsig.org
# Resume :    pci2geotiff http://www.portailsig.org/content/pci2geotiff
#
###############################################################################
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 3 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
###############################################################################


from PyQt4.QtCore import *
from PyQt4.QtGui import *
from ui_pci2geotiffAbout import Ui_pci2geotiffAbout
import webbrowser, os
import sys



#class pci2geotiffAboutGui(QDialog, QObject, Ui_pci2geotiffAbout):
#class pci2geotiffAboutGui(QDialog,Ui_pci2geotiffAbout):
class pci2geotiffAboutGui(QDialog):

	def __init__(self, parent=None):
		super(pci2geotiffAboutGui, self).__init__(parent)
		self.createWidgets()
		self.ui.lblVersion.setText("version 1")
		self.ui.txtAbout.setHtml(self.getText())
		self.ui.gridlayout.addWidget(self.ui.txtAbout, 2, 0, 30, 5)

	def createWidgets(self):
		self.ui = Ui_pci2geotiffAbout()
		self.ui.setupUi(self)
		QObject.connect(self.ui.btnWeb, SIGNAL("clicked()"), self.openWeb)


    
	def openWeb(self):
		webbrowser.open("http://www.portailsig.org")
        
	def getText(self):
		return self.tr(u""" <b>Auteurs : </b> Ludovic Granjon et Martin Laloux
<br />
<b>Organisation : </b> portailSIG - www.portailsig.org
<br />
<b>Licence : </b><i>GPL-3</i>
<p align=\"justify\">
Développée par le portailSIG, cet outil est destiné à géoréférencer les PCIRaster (cadastre au format image) accompagnés des fichiers GEO_*.txt décrivant les points d'amer, livré par la Direction Générale des Impôts.
Cet outil ne crée pas de nouveaux fichiers tiff mais crée seulement le fichier worldfile de géoréférencement ainsi qu'un fichier prj si cela est demandé
</p>

<br />

<p align=\"justify\">
Contact : redaction [at] portailsig.org</a> </p>
<p align=\"justify\">
Nous diffusons cet outil sans garantie.
<br />
En utilisant cet outil, vous acceptez d'en prendre l'entière responsabilité.
</p>
<br />


""")

if __name__ == "__main__":
	app = QApplication(sys.argv)
	myapp = pci2geotiffAboutGui()
	myapp.show()
	sys.exit(app.exec_())

