# -*- coding: utf-8 -*-
#!/usr/bin/env python
 
###############################################################################
# pci2geotiff_main.py
#
# Auteurs :   Ludovic Granjon, Martin Laloux, redaction@portailsig.org
# Organisme : portailSIG, www.portailsig.org
# Resume :    pci2geotiff http://www.portailsig.org/content/pci2geotiff
#
###############################################################################
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 3 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
###############################################################################
 
from PyQt4 import QtCore, QtGui
 
class Ui_PCI2GeotiffBox(object):
    def setupUi(self, PCI2GeotiffBox):
        PCI2GeotiffBox.setObjectName("PCI2Geotiff")
        PCI2GeotiffBox.resize(460, 350)
        #
        self.centralwidget = QtGui.QWidget(PCI2GeotiffBox)
        self.centralwidget.setObjectName("centralwidget")
        #image communaute sig
        self.txt_img = QtGui.QTextEdit(self.centralwidget)
        self.txt_img.setGeometry(QtCore.QRect(0, 0, 460, 350))
        self.txt_img.setReadOnly(True)
        self.txt_img.setObjectName("img_communauteSIG")
        self.txt_img.setHtml("<img src=\"img/community_sig2.png\">")
        #Boutons
        self.b_lancer = QtGui.QPushButton(self.centralwidget)
        self.b_lancer.setGeometry(QtCore.QRect(230, 220, 93, 27))
        self.b_lancer.setObjectName("b_lancer")
        self.b_help = QtGui.QPushButton(self.centralwidget)
        self.b_help.setGeometry(QtCore.QRect(130, 220, 93, 27))
        self.b_help.setObjectName("b_help")
        self.b_about = QtGui.QPushButton(self.centralwidget)
        self.b_about.setGeometry(QtCore.QRect(30, 220, 93, 27))
        self.b_about.setObjectName("b_about")
        self.b_Close = QtGui.QPushButton(self.centralwidget)
        self.b_Close.setGeometry(QtCore.QRect(330, 220, 93, 27))
        self.b_Close.setObjectName("b_Close")        
 
        #Chemin dossier
        self.b_parcourir = QtGui.QPushButton(self.centralwidget)
        self.b_parcourir.setGeometry(QtCore.QRect(330, 120, 93, 27))
        self.b_parcourir.setObjectName("b_parcourir_")
        self.cheminDossier = QtGui.QLineEdit(self.centralwidget)
        self.cheminDossier.setGeometry(QtCore.QRect(32, 120, 271, 27))
        self.cheminDossier.setObjectName("cheminDossier")        
        self.lbl_chemin = QtGui.QLabel(self.centralwidget)
        self.lbl_chemin.setGeometry(QtCore.QRect(40, 95, 401, 17))
        self.lbl_chemin.setObjectName("lbl_chemin")        

        #Projection
        self.lst_Proj = QtGui.QComboBox(self.centralwidget)
        self.lst_Proj.setGeometry(QtCore.QRect(32, 180, 271, 27))
        self.lst_Proj.setObjectName("lst_Proj")
        self.lbl_Proj = QtGui.QLabel(self.centralwidget)
        self.lbl_Proj.setGeometry(QtCore.QRect(40, 155, 401, 17))
        self.lbl_Proj.setObjectName("lbl_Proj")

        self.lbl_patience = QtGui.QLabel(self.centralwidget)
        self.lbl_patience.setGeometry(QtCore.QRect(60, 260, 261, 17))
        font = QtGui.QFont()
        font.setPointSize(16)
        font.setWeight(75)
        font.setBold(True)
        self.lbl_patience.setFont(font)
        self.lbl_patience.setObjectName("lbl_patience")
 
        self.pbar1 = QtGui.QProgressBar(self.centralwidget)
        self.pbar1.setGeometry(QtCore.QRect(60, 280, 261, 25))
        self.pbar1.setMinimum(0)
        self.pbar1.setMaximum(0)        
 
        PCI2GeotiffBox.setCentralWidget(self.centralwidget)
 
        self.retranslateUi(PCI2GeotiffBox)
 
 
        QtCore.QMetaObject.connectSlotsByName(PCI2GeotiffBox)
        QtCore.QObject.connect(self.b_Close, QtCore.SIGNAL("clicked()"), PCI2GeotiffBox.close)
 
    def retranslateUi(self, PCI2GeotiffBox):
        PCI2GeotiffBox.setWindowTitle(QtGui.QApplication.translate("PCI2GeotiffBox", "PCI2Geotiff", None, QtGui.QApplication.UnicodeUTF8))
 
        self.b_Close.setText(QtGui.QApplication.translate("MainWindow", "Quitter", None, QtGui.QApplication.UnicodeUTF8))        
        ###
        self.b_lancer.setText(QtGui.QApplication.translate("MainWindow", "Lancer", None, QtGui.QApplication.UnicodeUTF8))
        self.b_help.setText(QtGui.QApplication.translate("MainWindow", "Aide", None, QtGui.QApplication.UnicodeUTF8))
        self.b_about.setText(QtGui.QApplication.translate("MainWindow", "A propos", None, QtGui.QApplication.UnicodeUTF8))
        self.b_parcourir.setText(QtGui.QApplication.translate("MainWindow", "Parcourir", None, QtGui.QApplication.UnicodeUTF8))
        self.lbl_chemin.setText(QtGui.QApplication.translate("MainWindow", "Chemin vers le dossier contenant les tiffs à traiter :", None, QtGui.QApplication.UnicodeUTF8))
        self.lbl_Proj.setText(QtGui.QApplication.translate("MainWindow", "Choisissez la projection :", None, QtGui.QApplication.UnicodeUTF8))
        self.lbl_patience.setText(QtGui.QApplication.translate("MainWindow", "Veuillez patienter ...", None, QtGui.QApplication.UnicodeUTF8))
 
if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    PCI2GeotiffBox = QtGui.QMainWindow()
    ui = Ui_PCI2GeotiffBox()
    ui.setupUi(PCI2GeotiffBox)
    PCI2GeotiffBox.show()
    sys.exit(app.exec_())

