#!/usr/bin/env python
# -*- coding: utf-8 -*-

###############################################################################
# pci2geotiff_main.py
#
# Auteurs :   Ludovic Granjon, Martin Laloux, redaction@portailsig.org
# Organisme : portailSIG, www.portailsig.org
# Resume :    Il s'agit de l'interface graphique de pci2geotiff
#             pci2geotiff http://www.portailsig.org/content/pci2geotiff
#
###############################################################################
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 3 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
###############################################################################
 
import sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
 
from pci2geotiff_gui import Ui_PCI2GeotiffBox
from pci2geotiffAboutGui import pci2geotiffAboutGui
from pci2geotiff_class import pci2geotiff_exe,projXml

import locale
 
import webbrowser, os
 
class ArchaeDynApplication(QMainWindow):
 
	def __init__(self, parent=None):
		super(ArchaeDynApplication, self).__init__(parent)
		self.createWidgets()
		self.thread_pci2geotiff = t_pci2geotiff()
		self.remplirProj()
		self.connect(self.ui.b_lancer, SIGNAL("clicked()"), self.lancerThread_pci2geotiff)
		self.connect(self.thread_pci2geotiff, SIGNAL("terminated()"), self.update_pci2geotiff_ui)
		self.connect(self.thread_pci2geotiff, SIGNAL("finished()"), self.update_pci2geotiff_ui)
 
	def createWidgets(self):
		self.ui = Ui_PCI2GeotiffBox()
		self.ui.setupUi(self)
 
		self.ui.lbl_patience.setVisible(False)
		self.ui.pbar1.setVisible(False)
		self.ui.cheminDossier.setReadOnly(True)
 
		QObject.connect(self.ui.b_parcourir, SIGNAL("clicked()"), self.parcourir)
		QObject.connect(self.ui.b_about, SIGNAL("clicked()"), self.aPropos)
		QObject.connect(self.ui.b_help, SIGNAL("clicked()"), self.aide_pci2geotiff)
 
	def f_encode(self):
		#On crée un dictionnaire d'encodage
		d_encodage = {'UTF8':'utf-8', 'cp1252':'cp1252'}
		#On récupère l'encodage local
		encoder = locale.getdefaultlocale()
		#On fait le lien avec le dictionnaire
		encodage = d_encodage[encoder[1]]
		return encodage
 
	def aPropos(self):
		d = pci2geotiffAboutGui(self)
		d.show()
 
	def parcourir(self):
		filename = unicode(QFileDialog.getExistingDirectory(self, "Select Directory"))
		self.ui.cheminDossier.setText(filename)
  
	def aide_pci2geotiff(self):
		webbrowser.open(os.path.abspath('aide/aide_pci2geotiff.html'))
 
	def lancerThread_pci2geotiff(self):
		self.ui.lbl_patience.setVisible(True)
		self.ui.pbar1.setVisible(True)
		chemin_brut = unicode(self.ui.cheminDossier.text())
		chemin = chemin_brut.encode(self.f_encode())
		proj_brut = unicode(self.ui.lst_Proj.currentText())
		proj = proj_brut.encode(self.f_encode())
		try:
			if chemin_brut != '':
				self.thread_pci2geotiff.Lancer_pci2geotiff(chemin,proj)
			else:
				QMessageBox.warning(self,"Warning",u"Vous n'avez pas spécifier un chemin valide")
		except:
			QMessageBox.warning(self,"Warning",u"Un problème est arrivé")
 
	def update_pci2geotiff_ui(self):
		QMessageBox.information(self,"Information",u"Votre traitement est terminée")
		self.ui.lbl_patience.setVisible(False)
		self.ui.pbar1.setVisible(False)
		self.ui.cheminDossier.clear()
		
	def remplirProj(self, xml='proj.xml'):
                self.mesProjection = projXml(xml)
                self.mesProjection.lireXmlProj()
                mesProj = self.mesProjection.projections.keys()
                mesProj.sort()
		self.ui.lst_Proj.clear()
		self.ui.lst_Proj.insertItems(0,mesProj)
 
class t_pci2geotiff(QThread):
 
	def __init__(self, parent = None):
 
		QThread.__init__(self, parent)
		self.exiting = False
		self.chemin = ''
 
	def __del__(self):
 
		self.exiting = True
		self.wait()
 
	def Lancer_pci2geotiff(self, chemin,proj):
		self.chemin = chemin
		if proj =='Indefinie':
			self.proj = None
		else:
			self.proj = proj
		self.start()
 
	def run(self):
		pci2geotiff_exe(self.chemin,self.proj)
 
if __name__ == "__main__":
	app = QApplication(sys.argv)
	myapp = ArchaeDynApplication()
	myapp.show()
	QCoreApplication.processEvents()
	sys.exit(app.exec_())

