#!/usr/bin/env python
# -*- coding: utf-8 -*-

###############################################################################
# pci2geotiff_class.py
#
# Auteurs :   Ludovic Granjon, Martin Laloux, redaction@portailsig.org
# Organisme : portailSIG, www.portailsig.org
# Resume :    pci2geotiff http://www.portailsig.org/content/pci2geotiff
#
###############################################################################
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 3 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
###############################################################################

from PyQt4 import QtCore, QtGui

class Ui_pci2geotiffAbout(object):
    def setupUi(self, pci2geotiffAbout):
        pci2geotiffAbout.setObjectName("pci2geotiffAbout")
        pci2geotiffAbout.resize(600, 380)
        self.gridlayout = QtGui.QGridLayout(pci2geotiffAbout)
        self.gridlayout.setObjectName("gridlayout")
        self.txtAbout = QtGui.QTextEdit(pci2geotiffAbout)
        palette = QtGui.QPalette()
        brush = QtGui.QBrush(QtGui.QColor(0, 0, 0, 0))
        brush.setStyle(QtCore.Qt.SolidPattern)
        palette.setBrush(QtGui.QPalette.Active, QtGui.QPalette.Base, brush)
        brush = QtGui.QBrush(QtGui.QColor(0, 0, 0, 0))
        brush.setStyle(QtCore.Qt.SolidPattern)
        palette.setBrush(QtGui.QPalette.Inactive, QtGui.QPalette.Base, brush)
        brush = QtGui.QBrush(QtGui.QColor(255, 255, 255))
        brush.setStyle(QtCore.Qt.SolidPattern)
        palette.setBrush(QtGui.QPalette.Disabled, QtGui.QPalette.Base, brush)
        self.txtAbout.setPalette(palette)
        self.txtAbout.setAutoFillBackground(True)
        self.txtAbout.setFrameShape(QtGui.QFrame.NoFrame)
        self.txtAbout.setFrameShadow(QtGui.QFrame.Plain)
        self.txtAbout.setReadOnly(True)
        self.txtAbout.setObjectName("txtAbout")
        self.gridlayout.addWidget(self.txtAbout, 2, 0, 1, 3)
        spacerItem = QtGui.QSpacerItem(20, 10, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        self.gridlayout.addItem(spacerItem, 3, 1, 1, 1)
        self.btnClose = QtGui.QPushButton(pci2geotiffAbout)
        self.btnClose.setObjectName("btnClose")
        self.gridlayout.addWidget(self.btnClose, 4, 3, 1, 1)
        self.btnWeb = QtGui.QPushButton(pci2geotiffAbout)
        self.btnWeb.setObjectName("btnWeb")
        self.gridlayout.addWidget(self.btnWeb, 4, 1, 1, 1)
        self.lblVersion = QtGui.QLabel(pci2geotiffAbout)
        self.lblVersion.setObjectName("lblVersion")
        self.gridlayout.addWidget(self.lblVersion, 1, 0, 1, 2)
        self.lblTitle = QtGui.QLabel(pci2geotiffAbout)
        font = QtGui.QFont()
        font.setFamily("Sans Serif")
        font.setPointSize(20)
        font.setWeight(75)
        font.setBold(True)
        self.lblTitle.setFont(font)
        self.lblTitle.setTextFormat(QtCore.Qt.RichText)
        self.lblTitle.setObjectName("lblTitle")
        self.gridlayout.addWidget(self.lblTitle, 0, 0, 1, 3)

        self.retranslateUi(pci2geotiffAbout)
        QtCore.QObject.connect(self.btnClose, QtCore.SIGNAL("clicked()"), pci2geotiffAbout.reject)
        QtCore.QMetaObject.connectSlotsByName(pci2geotiffAbout)

    def retranslateUi(self, pci2geotiffAbout):
        pci2geotiffAbout.setWindowTitle(QtGui.QApplication.translate("pci2geotiffAbout", "A propos - PCI2GeoTiff", None, QtGui.QApplication.UnicodeUTF8))
        self.txtAbout.setHtml(QtGui.QApplication.translate("pci2geotiffAbout", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'Sans\'; font-size:10pt; font-weight:400; font-style:normal;\">\n"
"<p style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-family:\'Sans Serif\'; font-size:9pt;\"></p></body></html>", None, QtGui.QApplication.UnicodeUTF8))
        self.btnClose.setText(QtGui.QApplication.translate("pci2geotiffAbout", "Close", None, QtGui.QApplication.UnicodeUTF8))
        self.btnWeb.setText(QtGui.QApplication.translate("pci2geotiffAbout", "Web", None, QtGui.QApplication.UnicodeUTF8))
        self.lblVersion.setText(QtGui.QApplication.translate("pci2geotiffAbout", "Version x.x-xxxxxx", None, QtGui.QApplication.UnicodeUTF8))
        self.lblTitle.setText(QtGui.QApplication.translate("pci2geotiffAbout", "PCI2GeoTiff", None, QtGui.QApplication.UnicodeUTF8))


if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    pci2geotiffAbout = QtGui.QDialog()
    ui = Ui_pci2geotiffAbout()
    ui.setupUi(pci2geotiffAbout)
    pci2geotiffAbout.show()
    sys.exit(app.exec_())

